package com.ejie.ab04b.control;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.ab04b.constantes.Constantes;
import com.ejie.ab04b.model.ModalidadOrganizacionPreventiva;
import com.ejie.ab04b.service.ModalidadOrganizacionPreventivaService;
import com.ejie.ab04b.util.UtilidadesWar;
import com.ejie.ab04b.util.Utilities;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Ab0474s00Controller generated by UDA, 25-may-2017 13:40:42.
 * 
 * @author UDA
 */

@Controller()
@RequestMapping(value = "/modalidadorganizacionpreventiva")
public class ModalidadOrganizacionPreventivaController {

	private static final Logger logger = LoggerFactory
			.getLogger(ModalidadOrganizacionPreventivaController.class);

	@Autowired()
	private ModalidadOrganizacionPreventivaService modalidadOrganizacionPreventivaService;
	@Autowired()
	private ReloadableResourceBundleMessageSource messageSource;

	/**
	 * Usamos este mÃ©todo para indicarle a Spring el formato que debe usar para
	 * serializar las fechas cuando cargamos la entidad en el Model. En el resto
	 * de peticiones que devuelven un objeto con la anotaciÃ³n '@ResponseBody'
	 * se usan los serializadores de UDA
	 * 
	 *  binder
	 *            WebDataBinder
	 *
	 * @param binder the binder
	 */
	@InitBinder()
	public void initBinder(WebDataBinder binder) {

		Locale locale = LocaleContextHolder.getLocale();
		DateFormat dateFormat = null;
		if (locale.equals(Constantes.LOCALE_ES)) {
			dateFormat = new SimpleDateFormat(Constantes.ES_DATE_MASK);
		} else {
			dateFormat = new SimpleDateFormat(Constantes.EU_DATE_MASK);
		}
		binder.registerCustomEditor(Date.class,
				new CustomDateEditor(dateFormat, true));
	}

	/*
	 * OPERACIONES CRUD (Create, Read, Update, Delete)
	 */

	/**
	 * Operacion CRUD Read. Devuelve el bean correspondiente al identificador
	 * indicado.
	 * 
	 *  tipmpr074
	 *            String
	 *
	 * @param tipmpr074 the tipmpr 074
	 *  Ab0474s00 Objeto correspondiente al identificador indicado.
	 * @return the modalidad organizacion preventiva
	 */
	@RequestMapping(value = "/{tipmpr074}", method = RequestMethod.GET)
	public @ResponseBody ModalidadOrganizacionPreventiva get(
			@PathVariable String tipmpr074) {
		ModalidadOrganizacionPreventiva modalidadOrganizacionPreventiva = new ModalidadOrganizacionPreventiva();
		modalidadOrganizacionPreventiva.setTipmpr074(tipmpr074);
		modalidadOrganizacionPreventiva = this.modalidadOrganizacionPreventivaService
				.find(modalidadOrganizacionPreventiva);
		ModalidadOrganizacionPreventivaController.logger
				.info("[GET - findBy_PK] : Obtener Ab0474s00 por PK");
		return modalidadOrganizacionPreventiva;
	}

	/**
	 * Devuelve una lista de beans correspondientes a los valores de filtrados
	 * indicados en el objeto pasado como parametro.
	 * 
	 *  filterModalidadOrganizacionPreventiva the filter modalidad organizacion preventiva
	 *
	 * @param filterModalidadOrganizacionPreventiva the filter modalidad organizacion preventiva
	 *  List<Ab0474s00> Lista de objetos correspondientes a la busqueda
	 *         realizada.
	 * @return the all
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<ModalidadOrganizacionPreventiva> getAll(
			@ModelAttribute ModalidadOrganizacionPreventiva filterModalidadOrganizacionPreventiva) {
		ModalidadOrganizacionPreventivaController.logger.info(
				"[GET - find_ALL] : Obtener ModalidadOrganizacionPreventiva por filtro");
		return this.modalidadOrganizacionPreventivaService
				.findAll(filterModalidadOrganizacionPreventiva, null);
	}

	/**
	 * Operacion CRUD Edit. Modificacion del bean indicado.
	 * 
	 *  modalidadOrganizacionPreventiva the modalidad organizacion preventiva
	 *
	 * @param modalidadOrganizacionPreventiva the modalidad organizacion preventiva
	 *  Ab0474s00 Bean resultante de la modificacion.
	 * @return the modalidad organizacion preventiva
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody ModalidadOrganizacionPreventiva edit(
			@RequestBody ModalidadOrganizacionPreventiva modalidadOrganizacionPreventiva) {
		ModalidadOrganizacionPreventiva ModalidadOrganizacionPreventivaAux = this.modalidadOrganizacionPreventivaService
				.update(modalidadOrganizacionPreventiva);
		ModalidadOrganizacionPreventivaController.logger.info(
				"[PUT] : ModalidadOrganizacionPreventiva actualizado correctamente");
		return ModalidadOrganizacionPreventivaAux;
	}

	/**
	 * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean
	 * indicado.
	 * 
	 *  modalidadOrganizacionPreventiva the modalidad organizacion preventiva
	 *
	 * @param modalidadOrganizacionPreventiva the modalidad organizacion preventiva
	 *  Ab0474s00 Bean resultante del proceso de creacion.
	 * @return the modalidad organizacion preventiva
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody ModalidadOrganizacionPreventiva add(
			@RequestBody ModalidadOrganizacionPreventiva modalidadOrganizacionPreventiva) {
		ModalidadOrganizacionPreventiva modalidadOrganizacionPreventivaAux = this.modalidadOrganizacionPreventivaService
				.add(modalidadOrganizacionPreventiva);
		ModalidadOrganizacionPreventivaController.logger.info(
				"[POST] : ModalidadOrganizacionPreventiva insertado correctamente");
		return modalidadOrganizacionPreventivaAux;
	}

	/**
	 * Operacion CRUD Delete. Borrado del registro correspondiente al
	 * identificador especificado.
	 * 
	 *  tipmpr074
	 *            String Identificador del objeto que se desea eliminar.
	 *
	 * @param tipmpr074 the tipmpr 074
	 *  Ab0474s00 Bean eliminado.
	 * @return the modalidad organizacion preventiva
	 */
	@RequestMapping(value = "/{tipmpr074}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody ModalidadOrganizacionPreventiva remove(
			@PathVariable String tipmpr074) {
		ModalidadOrganizacionPreventiva modalidadOrganizacionPreventiva = new ModalidadOrganizacionPreventiva();
		modalidadOrganizacionPreventiva.setTipmpr074(tipmpr074);
		this.modalidadOrganizacionPreventivaService
				.remove(modalidadOrganizacionPreventiva);
		ModalidadOrganizacionPreventivaController.logger.info(
				"[DELETE] : ModalidadOrganizacionPreventiva borrado correctamente");
		return modalidadOrganizacionPreventiva;
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE
	 */

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 *  model
	 *            Model
	 *
	 * @param model the model
	 *  String
	 * @return the form edit
	 */
	@RequestMapping(value = "/maint", method = RequestMethod.GET)
	public String getFormEdit(Model model) {
		ModalidadOrganizacionPreventivaController.logger
				.info("[GET - View] : ModalidadOrganizacionPreventiva");
		return "modalidadorganizacionpreventiva";
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 *  filterModalidadOrganizacionPreventiva the filter modalidad organizacion preventiva
	 *  jqGridRequestDto            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 *
	 * @param filterModalidadOrganizacionPreventiva the filter modalidad organizacion preventiva
	 * @param jqGridRequestDto the jq grid request dto
	 *  JQGridResponseDto<Ab0474s00> Dto que contiene el resultado del
	 *         filtrado realizado por el componente RUP_TABLE.
	 * @return the JQ grid response dto
	 */
	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody JQGridResponseDto<ModalidadOrganizacionPreventiva> filter(
			@RequestJsonBody(param = "filter") ModalidadOrganizacionPreventiva filterModalidadOrganizacionPreventiva,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		ModalidadOrganizacionPreventivaController.logger.info(
				"[POST - filter] : Obtener ModalidadOrganizacionPreventiva");
		return this.modalidadOrganizacionPreventivaService.filter(
				filterModalidadOrganizacionPreventiva, jqGridRequestDto, false);
	}

	/**
	 * Operacion de busqueda del componente RUP_TABLE.
	 * 
	 *  filterAb0474s00
	 *            Ab0474s00 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 *  searchAb0474s00
	 *            Ab0474s00 Bean que contiene los parametros de busqueda a
	 *            emplear.
	 *  jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la búsqueda.
	 *
	 * @param filterAb0474s00 the filter ab 0474 s 00
	 * @param searchAb0474s00 the search ab 0474 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 *  TableRowDto<Ab0474s00> Dto que contiene el resultado de la
	 *         busqueda realizada por el componente RUP_TABLE.
	 * @return the list
	 */
	@RequestMapping(value = "/search", method = RequestMethod.POST)
	public @ResponseBody List<TableRowDto<ModalidadOrganizacionPreventiva>> search(
			@RequestJsonBody(param = "filter") ModalidadOrganizacionPreventiva filterAb0474s00,
			@RequestJsonBody(param = "search") ModalidadOrganizacionPreventiva searchAb0474s00,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		ModalidadOrganizacionPreventivaController.logger.info(
				"[POST - search] : Buscar ModalidadOrganizacionPreventiva");
		return this.modalidadOrganizacionPreventivaService.search(
				filterAb0474s00, searchAb0474s00, jqGridRequestDto, false);
	}

	/**
	 * Borrado multiple de registros.
	 * 
	 *  filterModalidadOrganizacionPreventiva the filter modalidad organizacion preventiva
	 *  jqGridRequestDto            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la busqueda.
	 *
	 * @param filterModalidadOrganizacionPreventiva the filter modalidad organizacion preventiva
	 * @param jqGridRequestDto the jq grid request dto
	 *  List<String> Lista de los identificadores de los registros
	 *         eliminados.
	 * @return the list
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody List<String> removeMultiple(
			@RequestJsonBody(param = "filter") ModalidadOrganizacionPreventiva filterModalidadOrganizacionPreventiva,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		ModalidadOrganizacionPreventivaController.logger.info(
				"[POST - search] : [POST - removeMultiple] : Eliminar multiples ModalidadOrganizacionPreventiva");
		this.modalidadOrganizacionPreventivaService.removeMultiple(
				filterModalidadOrganizacionPreventiva, jqGridRequestDto, false);
		ModalidadOrganizacionPreventivaController.logger
				.info("All entities correctly deleted!");

		return jqGridRequestDto.getMultiselection().getSelectedIds();
	}

	/**
	 * Realiza la exportaciÃ³n a Excel.
	 * 
	 *  filterModalidadOrganizacionPreventiva            Expediente Bean que contiene los parÃ¡metros de filtrado a
	 *            emplear.
	 *  jqGridRequestDto            JQGridRequestDto que contiene los parÃ¡mtros de configuraciÃ³n
	 *            propios del RUP_TABLE a aplicar en el filtrado.
	 *  modelMap            ModelMap
	 *  columns            String
	 *  request            HttpServletRequest
	 *
	 * @param filterModalidadOrganizacionPreventiva the filter modalidad organizacion preventiva
	 * @param jqGridRequestDto the jq grid request dto
	 * @param modelMap the model map
	 * @param columns the columns
	 * @param request the request
	 *  ModelAndView
	 * @return the report
	 */
	@RequestMapping(value = { "xlsReport",
			"xlsxReport" }, method = RequestMethod.POST)
	protected ModelAndView getReport(
			@ModelAttribute() ModalidadOrganizacionPreventiva filterModalidadOrganizacionPreventiva,
			@ModelAttribute() JQGridRequestDto jqGridRequestDto,
			ModelMap modelMap,
			@RequestParam(value = "columns", required = false) String columns,
			HttpServletRequest request) {

		// Limpiamos los datos de paginacion para mostrar todos los registros
		jqGridRequestDto.setPage(null);
		jqGridRequestDto.setRows(null);

		// Acceso a BD para recuperar datos
		List<ModalidadOrganizacionPreventiva> listModalidadOrganizacionPreventiva = this.modalidadOrganizacionPreventivaService
				.findAllLike(filterModalidadOrganizacionPreventiva,
						jqGridRequestDto, false);

		// GENERAMOS EL FICHERO
		UtilidadesWar.generateReport(modelMap,
				Utilities.getLiteralMessage(this.messageSource,
						"excel.titulo.modalidadOrganizacionPreventiva"),
				columns, listModalidadOrganizacionPreventiva);

		// GeneraciÃ³n del XLS o XLSX
		if (request.getServletPath().indexOf("xlsReport") != -1) {
			return new ModelAndView("xlsReport", modelMap);
		} else {
			return new ModelAndView("xlsxReport", modelMap);
		}
	}
}
